// BorderTron3000 - SAM Coup Edition
//
// Copyright (c)2012 Chris Cowley <chrrris@gmail.com>
//
// Source Licence Terms:
//         1. Please credit me if you re-use this code.
//         2. If you find a way of making money from it, please send me some.
//
// GrokUtils.pas - Some handy utility functions.
unit GrokUtils;

interface

uses Classes;

function Sto_GetFileSize(const FileName: String): Int64;
function StreamGetString(F: TStream; out bEOF: boolean): string;
procedure StringToBytes(s: AnsiString; P: PByte);
function GetXORChecksum(P: PByte; iLength: integer): Byte;

implementation

uses SysUtils, FMX.Forms;

////////////////////////////////////////////////////////////////
// this function determines the size of a file in bytes, the size
// can be more than 2 GB.

function Sto_GetFileSize(const FileName: String): Int64;
var
  myFile: File of byte;
  //myFindData: TWin32FindData;
begin
  // set default value
  Result := 0;
  // get the file handle.
  if FileExists(FileName) then
  begin
    AssignFile(myFile,FileName);
    Reset(myFile);
    Result := FileSize(myFile);
    CloseFile(myFile);
  end;
end;

{ // Removed due to it being non-portable
function Sto_GetFileSize(const FileName: String): Int64;
var
  myFile: THandle;
  myFindData: TWin32FindData;
begin
  // set default value
  Result := 0;
  // get the file handle.
  myFile := FindFirstFile(PChar(FileName), myFindData);
  if (myFile <> INVALID_HANDLE_VALUE) then
  begin
    Windows.FindClose(myFile);
    Int64Rec(Result).Lo := myFindData.nFileSizeLow;
    Int64Rec(Result).Hi := myFindData.nFileSizeHigh;
  end;
end;
}

function StreamGetString(F: TStream; out bEOF: boolean): string;
var
  i, iLen: integer;
  c: array [0..1026] of byte;
begin
  bEOF := true;

  iLen := F.Read(c,1024);
  for i := 0 to iLen-2 do begin
    if (c[i] = 13) and (c[i+1] = 10) then
    begin
      F.Seek(-iLen+i+2,soFromCurrent);
      SetString(Result,PAnsiChar(@c[0]),i);
      bEOF := false;
      break;
    end;
  end;

  if bEof then
      SetString(Result,PAnsiChar(@c[0]),iLen);
end;

procedure StringToBytes(s: AnsiString; P: PByte);
var
  i: Integer;
begin
  for i := 1 to Length(s) do
  begin
    PByte(P)^ := Ord(s[i]);
    inc(P);
  end;
end;

function GetXORChecksum(P: PByte; iLength: integer): Byte;
var
  i: Integer;
begin
  Result := P^;
  inc(P);
  for i := 1 to iLength - 1 do
  begin
    Result := Result xor P^;
    inc(P);
  end;
end;

end.
