# BASTRIS v2.0
#
# By Chris Cowley
# February 2002 - v1.0
# June     2014 - v2.0
#
# Use zmakebas from http://rus.members.beeb.net/zmakebas.html or
# BASin to strip out the '#' comments and turn this into a
# Speccy .TAP file!

  10 REM BASTRIS By Chris Cowley

# Default to Issue 3 keyboard
  25 GO SUB 600
# ...but set to issue 2 if IN 57088 = 191
  28 IF IN 57088 = 191 THEN GO SUB 500
  20 GOSUB 9700
  30 GOSUB 9500
  40 GOSUB 4700
  50 LET Piece=INT(RND*7)+1: LET rot=0: LET PieceClr=71+Piece*8
  60 GOSUB 3900 + Piece * 100 + Rot * 10
  70 LET y=32: LET x=14: LET newx=x: LET IsBottom=0: LET xy=22528+x+y
  80 GOSUB 3800
  90 GOSUB 3100
 100 GOSUB 3000
 110 IF IsBottom AND y=32 THEN GOTO 200
 120 IF IsBottom THEN GOSUB 2000: GOTO 50
 140 GOSUB 3850
 150 LET y=y+32: LET x=newx: LET xy=22528+x+y
 160 GOTO 80

#
# Issue 2 Keyboard values
#
 500 LET KeyLeft = 189: LET KeyRight = 190
 510 LET KeyUp = 190: LET KeyDown = 190
 520 RETURN

#
# Issue 3 Keyboard values
#
 600 LET KeyLeft = 253: LET KeyRight = 254
 610 LET KeyUp = 254: LET KeyDown = 254
 620 RETURN

#
# Game Over
#
 200 PRINT AT 9,10;INK 2; PAPER 1;"\b\o\o\o\o\o\o\o\o\o\o\c"
 210 PRINT AT 10,10;INK 2;"\o";INK 7;"Game  Over";INK 2;"\o"
 220 PRINT AT 11,10;INK 2; PAPER 1;"\d\o\o\o\o\o\o\o\o\o\o\e"
 230 INK 6: PAPER 0: FLASH 1: GOSUB 9800
 240 IF INKEY$<>"" THEN GOTO 240
 250 FOR N=1 TO 1400: NEXT N
 260 GOTO 30

#
# Check for completed lines
#
2000 FOR N=22560 TO 23168 STEP 32
2010 LET Row=-1
2015 FOR M=11 TO 20
2020 IF PEEK(M+N) = 0 THEN LET Row=0: LET M=20
2025 NEXT M
2030 IF Row THEN GOSUB 2100
2040 NEXT N
2050 RETURN

#
# Remove Row N
#
2100 FOR R=N TO 22560 STEP -32
2105 LET Row=0
2110 FOR M=11 TO 20
2115 POKE M+R,PEEK(M+R-32)
2118 IF PEEK(M+R)<>0 THEN LET Row=-1
2120 NEXT M
2122 IF NOT Row THEN LET R=1
2125 NEXT R
2130 LET Lines=Lines+1
2135 IF Lines>9999 THEN PRINT AT 4,24;Lines: RETURN
2140 IF Lines>999 THEN PRINT AT 4,25;Lines: RETURN
2145 IF Lines>99 THEN PRINT AT 4,26;Lines: RETURN
2150 IF Lines>9 THEN PRINT AT 4,27;Lines: RETURN
2155 PRINT AT 4,28;Lines
2160 BEEP .1,40
2170 RETURN

#
# Is the current piece "Bottomed Out" (F'NAR!)
#
3000 LET p1=xy+b(1,1)+b(1,2)
3002 LET p2=xy+b(2,1)+b(2,2)
3004 LET p3=xy+b(3,1)+b(3,2)
3006 LET p4=xy+b(4,1)+b(4,2)
3010 LET n1=p1+32: LET n2=p2+32: LET n3=p3+32: LET n4=p4+32
3020 IF n1<>p2 AND n1<>p3 AND n1<>p4 AND PEEK(n1) <> 0 THEN LET IsBottom=-1: RETURN
3030 IF n2<>p1 AND n2<>p3 AND n2<>p4 AND PEEK(n2) <> 0 THEN LET IsBottom=-1: RETURN
3040 IF n3<>p1 AND n3<>p2 AND n3<>p4 AND PEEK(n3) <> 0 THEN LET IsBottom=-1: RETURN
3050 IF n4<>p1 AND n4<>p2 AND n4<>p3 AND PEEK(n4) <> 0 THEN LET IsBottom=-1: RETURN
3060 RETURN

#
# Read Keys + action them
#
3105 IF IN 57088=KeyRight THEN GOTO 3200
3110 IF IN 57088=KeyLeft THEN GOTO 3300
3115 IF IN 64256=KeyUp THEN GOTO 3400
3120 IF IN 64768=KeyDown THEN GOTO 3500
3125 RETURN

### Move Right ###
3200 LET low=0
3202 IF b(1,1) > low THEN LET low=b(1,1)
3204 IF b(2,1) > low THEN LET low=b(2,1)
3206 IF b(3,1) > low THEN LET low=b(3,1)
3208 IF b(4,1) > low THEN LET low=b(4,1)
3210 IF b(1,1)=low AND PEEK (xy+b(1,1)+1+b(1,2)) <> 0 THEN RETURN
3212 IF b(2,1)=low AND PEEK (xy+b(2,1)+1+b(2,2)) <> 0 THEN RETURN
3214 IF b(3,1)=low AND PEEK (xy+b(3,1)+1+b(3,2)) <> 0 THEN RETURN
3216 IF b(4,1)=low AND PEEK (xy+b(4,1)+1+b(4,2)) <> 0 THEN RETURN
3220 LET newx=x+1
3230 RETURN

### Move Left ###
3300 LET low=3
3302 IF b(1,1) < low THEN LET low=b(1,1)
3304 IF b(2,1) < low THEN LET low=b(2,1)
3306 IF b(3,1) < low THEN LET low=b(3,1)
3308 IF b(4,1) < low THEN LET low=b(4,1)
3310 IF b(1,1)=low AND PEEK (xy+b(1,1)-1+b(1,2)) <> 0 THEN RETURN
3312 IF b(2,1)=low AND PEEK (xy+b(2,1)-1+b(2,2)) <> 0 THEN RETURN
3314 IF b(3,1)=low AND PEEK (xy+b(3,1)-1+b(3,2)) <> 0 THEN RETURN
3316 IF b(4,1)=low AND PEEK (xy+b(4,1)-1+b(4,2)) <> 0 THEN RETURN
3320 LET newx=x-1
3330 RETURN

### Rotate ###
3400 LET Rot=Rot+1: IF Rot=4 THEN LET Rot=0
3405 GOSUB 3850
3410 GOSUB 3900 + Piece * 100 + Rot * 10
3412 LET Low=11
3414 IF x+b(1,1) < Low THEN LET Low = x+b(1,1)
3416 IF x+b(2,1) < Low THEN LET Low = x+b(2,1)
3418 IF x+b(3,1) < Low THEN LET Low = x+b(3,1)
3420 IF x+b(4,1) < Low THEN LET Low = x+b(4,1)
3422 IF Low < 11 THEN LET x=11: LET newx=11: LET xy=22528+x+y: GOSUB 3800: RETURN
3424 LET Low=20
3426 IF x+b(1,1) > Low THEN LET Low = x+b(1,1)
3428 IF x+b(2,1) > Low THEN LET Low = x+b(2,1)
3430 IF x+b(3,1) > Low THEN LET Low = x+b(3,1)
3432 IF x+b(4,1) > Low THEN LET Low = x+b(4,1)
3434 IF Low > 20 THEN LET x=x+20-Low: LET newx=x: LET xy=22528+x+y
3436 GOSUB 3800
3440 RETURN

### Drop ###
3500 GOSUB 3850
3510 GOSUB 3000
3520 IF IsBottom THEN GOSUB 3800: RETURN
3530 LET y=y+32: LET xy=22528+x+y
3540 GOTO 3510

#
# Draw Piece
#
3800 POKE xy+b(1,1)+b(1,2),PieceClr
3805 POKE xy+b(2,1)+b(2,2),PieceClr
3810 POKE xy+b(3,1)+b(3,2),PieceClr
3815 POKE xy+b(4,1)+b(4,2),PieceClr
3820 RETURN

#
# Undraw Piece
#
3850 POKE xy+b(1,1)+b(1,2),0
3855 POKE xy+b(2,1)+b(2,2),0
3860 POKE xy+b(3,1)+b(3,2),0
3865 POKE xy+b(4,1)+b(4,2),0
3870 RETURN

# Square Piece Rotations
##########################
4030 LET b(1,1)=1: LET b(1,2)=32: LET b(2,1)=2: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN

# Long Piece Rotations
##########################
4100 LET b(1,1)=0: LET b(1,2)=32: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=3: LET b(4,2)=32: RETURN
4110 LET b(1,1)=2: LET b(1,2)=0: LET b(2,1)=2: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=96: RETURN
4120 LET b(1,1)=0: LET b(1,2)=64: LET b(2,1)=1: LET b(2,2)=64: LET b(3,1)=2: LET b(3,2)=64: LET b(4,1)=3: LET b(4,2)=64: RETURN
4130 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=1: LET b(4,2)=96: RETURN

# T-Piece Rotations
#####################
4200 LET b(1,1)=1: LET b(1,2)=32: LET b(2,1)=0: LET b(2,2)=64: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN
4210 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=1: LET b(4,2)=64: RETURN
4220 LET b(1,1)=1: LET b(1,2)=32: LET b(2,1)=2: LET b(2,2)=32: LET b(3,1)=3: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=64: RETURN
4230 LET b(1,1)=2: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=64: RETURN

# L-Piece Type 1 Rotations
############################
4300 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=2: LET b(2,2)=0: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=64: RETURN
4310 LET b(1,1)=2: LET b(1,2)=0: LET b(2,1)=0: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=32: RETURN
4320 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN
4330 LET b(1,1)=0: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=0: LET b(3,1)=2: LET b(3,2)=0: LET b(4,1)=0: LET b(4,2)=32: RETURN

# L-Piece Type 2 Rotations
############################
4400 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=2: LET b(2,2)=0: LET b(3,1)=1: LET b(3,2)=32: LET b(4,1)=1: LET b(4,2)=64: RETURN
4410 LET b(1,1)=0: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=0: LET b(3,1)=2: LET b(3,2)=0: LET b(4,1)=2: LET b(4,2)=32: RETURN
4420 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=0: LET b(3,2)=64: LET b(4,1)=1: LET b(4,2)=64: RETURN
4430 LET b(1,1)=0: LET b(1,2)=0: LET b(2,1)=0: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=32: RETURN

# S-Piece Type 1 Rotations
############################
4500 LET b(1,1)=0: LET b(1,2)=32: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN
4510 LET b(1,1)=2: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=1: LET b(4,2)=64: RETURN
4520 LET b(1,1)=0: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=0: LET b(3,1)=1: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=32: RETURN
4530 LET b(1,1)=2: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=1: LET b(4,2)=64: RETURN

# S-Piece Type 1 Rotations
############################
4600 LET b(1,1)=2: LET b(1,2)=32: LET b(2,1)=3: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN
4610 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=64: RETURN
4620 LET b(1,1)=2: LET b(1,2)=32: LET b(2,1)=3: LET b(2,2)=32: LET b(3,1)=1: LET b(3,2)=64: LET b(4,1)=2: LET b(4,2)=64: RETURN
4630 LET b(1,1)=1: LET b(1,2)=0: LET b(2,1)=1: LET b(2,2)=32: LET b(3,1)=2: LET b(3,2)=32: LET b(4,1)=2: LET b(4,2)=64: RETURN

#
# Initialize Game Screen + Variables
#
4700 RANDOMIZE
4705 INK 0: BRIGHT 0: CLS
4710 PRINT AT 1,10; INK 1;"\f"; INK 0;"\a\a\a\a\a\a\a\a\a\a"; INK 1;"\f"
4715 FOR N = 2 TO 20: PRINT AT N,10; PAPER 1;" ";PAPER 0;"\A\A\A\A\A\A\A\A\A\A";PAPER 1;" ": NEXT N
4720 PRINT AT 21,10;INK 1;"\D\O\O\O\O\O\O\O\O\O\O\E"
4725 PRINT AT 2,23; INK 5; BRIGHT 1;"\B\O\O\O\O\O\C"
4730 PRINT AT 3,23; INK 5; BRIGHT 1;"\O";INK 7;"Lines"; INK 5;"\O";AT 4,23; INK 5;"\O"; INK 7; BRIGHT 0; "00000"; INK 5; BRIGHT 1;"\O"
4735 PRINT AT 5,23; INK 5; BRIGHT 1;"\D\O\O\O\O\O\E"
4740 LET Lines=0: Dim b(4,2)
4745 INK 7
4750 RETURN

#
# Front Screen
#
9510 BORDER 0: PAPER 0: INK 7: BRIGHT 1: FLASH 0: CLS
9520 PRINT INK 2;"\o\o\o\c \b\o\o\c \b\o\o\c \o\o\o \o\o\o\c \o\o\o \b\o\o\c"
9522 PRINT INK 6;"\o  \o \o  \o \o     \o  \o  \o  \o  \o"
9524 PRINT INK 4;"\o\o\o\p \o\o\o\o \d\o\o\c  \o  \o\o\o\p  \o  \d\o\o\c"
9526 PRINT INK 5;"\o  \o \o  \o    \o  \o  \o  \o  \o     \o"
9528 PRINT INK 1;"\o  \o \o  \o \f  \o  \o  \o  \o  \o  \f  \o"
9530 PRINT INK 3;"\o\o\o\e \o  \o \d\o\o\e  \o  \o  \o \o\o\o \d\o\o\e"
9540 INK 6
9542 PRINT AT 8,14;"Keys:";AT 10,15;"\I \M"; AT 12,11;"\G\K       \L\H"; AT 14,15;"\J \N"
9544 PRINT AT 17,11;"Version 2.0"; AT 18,9; BRIGHT 0;"By Chris Cowley"
9546 INK 7
9550 PRINT AT 21,5;"Press any key to start"
9560 IF INKEY$ <> "" THEN GOTO 9560
9565 RESTORE 9600
9570 FOR N=1 TO 158
9572 READ X,Y
9574 FOR M=1 TO X: IF Y > -12 THEN BEEP .011,Y
9576 IF INKEY$ <> "" THEN RETURN
9578 NEXT M
9580 NEXT N
9585 GOTO 9565

### Tune Data ###
9600 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9602 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9604 DATA 8,0,4,12,4,15,4,6,8,5
9606 DATA 4,0,8,3,4,0,4,2,4,0,4,2,4,3,4,2
9610 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9612 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9614 DATA 8,0,4,12,4,15,4,6,8,5
9616 DATA 4,0,8,3,4,0,4,2,4,0,4,2,4,3,4,2
9620 DATA 8,5,4,17,4,20,4,11,8,10,4,17
9622 DATA 8,5,4,17,4,20,4,11,8,10,4,17
9624 DATA 8,5,4,17,4,20,4,11,8,10
9626 DATA 4,5,8,8,4,5,4,7,4,5,4,7,4,8,4,7
9630 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9632 DATA 8,0,4,12,4,15,4,6,8,5,4,12
9634 DATA 8,0,4,12,4,15,4,6,8,5
9636 DATA 4,0,8,3,4,0,4,2,4,0,4,2,4,3,4,2
9640 DATA 4,0,4,0,4,0,4,0,4,0,4,0,8,10
9642 DATA 4,0,4,0,4,0,4,0,4,0,4,0,8,9
9644 DATA 4,0,4,0,4,0,4,0,4,0,4,0,4,8
9646 DATA 8,3,4,0,4,2,4,0,4,2,4,3,4,2
9650 DATA 4,0,4,0,4,0,4,0,4,0,4,0,8,10
9652 DATA 4,0,4,0,4,0,4,0,4,0,4,0,8,9
9654 DATA 4,0,4,0,4,0,4,0,4,0,4,0,4,8
9656 DATA 8,3,5,0,6,2,6,0,6,2,8,3,16,2,22,0,180,-12

#
# Initialize UDG's
#
9700 RESTORE 9740
9705 FOR N=USR "a" TO USR "p"+7
9710 READ x: POKE N,x
9715 NEXT N
9720 RETURN
# A - Block
9740 DATA 250,192,128,128,128,0,128,0
# B - Top left corner
9742 DATA 0,7,31,63,127,255,255,255
# C - Top right corner
9744 DATA 0,224,248,252,254,255,255,255
# D - Bottom left corner
9746 DATA 255,255,255,127,63,31,7,0
# E - Bottom right corner
9748 DATA 255,255,255,254,252,248,224,0
# F - Top rounded piece
9750 DATA 24,126,255,255,255,255,255,255
# G - Left arrow <-
9752 DATA 16,48,126,254,126,48,16,0
# H - Right arrow ->
9754 DATA 16,24,252,254,252,24,16,0
# I - Rotate symbol @
9756 DATA 121,255,231,207,192,194,246,124
# J - Down arrow \/
9758 DATA 56,56,56,254,124,56,16,0
# K - Letter O
9760 DATA 124,254,198,198,198,254,124,0
# L - Letter P
9762 DATA 252,254,198,254,252,192,192,0
# M - Letter Q
9764 DATA 124,254,198,198,206,255,127,0
# N - Letter A
9766 DATA 124,254,198,254,254,198,198,0
# O - All the 1's (just for convenience rather than using spaces)
9768 DATA 255,255,255,255,255,255,255,255
# P - "<" Character used on front screen
9770 DATA 254,248,240,128,128,240,248,254

#
# Print number of Lines achieved
#
9800 PRINT AT 4,24;"00000"
9805 IF Lines>9999 THEN PRINT AT 4,24;Lines: RETURN
9810 IF Lines>999 THEN PRINT AT 4,25;Lines: RETURN
9815 IF Lines>99 THEN PRINT AT 4,26;Lines: RETURN
9820 IF Lines>9 THEN PRINT AT 4,27;Lines: RETURN
9825 PRINT AT 4,28;Lines
9830 RETURN
